<?php
/* -----------------------------------------------------------------
 * 	$Id: paypal_module.php 1548 2016-04-06 13:03:10Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	modified eCommerce Shopsoftware
 * 	http://www.modified-shop.org
 * 	Copyright (c) 2009 - 2013 [www.modified-shop.org]
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */


require('includes/application_top.php');

function get_module_info($module) {
  $module_info = array('code' => $module->code,
                       'title' => $module->title,
                       'description' => $module->description,
                       'extended_description' => isset($module->extended_description) ? $module->extended_description : '',
                       'status' => $module->check());
  $module_info['properties'] = isset($module->properties) ? $module->properties : array();
  $module_keys = method_exists($module,'keys') ? $module->keys() : array();
  $keys_extra = array();
  for ($j = 0, $k = sizeof($module_keys); $j < $k; $j++) {
    $key_value_query = xtc_db_query("SELECT configuration_key,
                                            configuration_value,
                                            use_function,
                                            set_function
                                       FROM " . TABLE_CONFIGURATION . "
                                      WHERE configuration_key = '" . $module_keys[$j] . "'");
    $key_value = xtc_db_fetch_array($key_value_query);
    if ($key_value['configuration_key'] !='') {
      $keys_extra[$module_keys[$j]]['title'] = constant(strtoupper($key_value['configuration_key'] .'_TITLE'));
    }
    $keys_extra[$module_keys[$j]]['value'] = $key_value['configuration_value'];
    if ($key_value['configuration_key'] !='') {
      $keys_extra[$module_keys[$j]]['description'] = constant(strtoupper($key_value['configuration_key'] .'_DESC'));
    }
    $keys_extra[$module_keys[$j]]['use_function'] = $key_value['use_function'];
    $keys_extra[$module_keys[$j]]['set_function'] = $key_value['set_function'];
  }
  $module_info['keys'] = $keys_extra;
  
  return $module_info;
}

// languages
$languages = xtc_get_languages(); 

$payment_array = array(
  'paypalplus',
  'paypalcart',
);

$status_array = array(
  array('id' => 1, 'text' => YES),
  array('id' => 0, 'text' => NO),
); 

// include needed classes
require_once(DIR_FS_EXTERNAL.'paypal/classes/PayPalAdmin.php');
$paypal = new PayPalAdmin();

if (isset($_GET['action'])) {
  switch ($_GET['action']) {
    case 'delete':
      $paypal->delete_webhook($_GET['id']);      
      xtc_redirect(xtc_href_link('paypal_module.php'));
      break;

    case 'update':
      if (isset($_POST['config'])) {
        if (isset($_POST['config']['thirdparty'])) {
          $thirdparty = array();
          foreach ($_POST['config']['thirdparty'] as $key => $value) {
            if ($value == '1') {
              $thirdparty[] = $key;
            }
          }
          xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_PAYPAL_PLUS_THIRDPARTY_PAYMENT'");
          xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, last_modified) VALUES ('MODULE_PAYMENT_PAYPAL_PLUS_THIRDPARTY_PAYMENT', '" . xtc_db_input(implode(';', $thirdparty)) . "', NOW())");
        }
        if (isset($_POST['config']['description'])) {
          $sql_data_array = array();
          foreach ($_POST['config']['description'] as $key => $value) {
            if ($value != '') {
              $sql_data_array[] = array(
                'config_key' => $key,
                'config_value' => $value,
              );
            } else {
              $paypal->delete_config($key);
            }
          }
          $paypal->save_config($sql_data_array);
        }
        if (isset($_POST['config']['profile'])) {
          $sql_data_array = array();
          foreach ($_POST['config']['profile'] as $key => $value) {
            $sql_data_array[] = array(
              'config_key' => $key,
              'config_value' => $value,
            );
          }
          $paypal->save_config($sql_data_array);
        }
      }
      if (isset($_POST['configuration']) && count($_POST['configuration']) > 0) {
        foreach ($_POST['configuration'] as $key => $value) {
          xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " SET configuration_value='" . xtc_db_input($value) . "', last_modified = NOW() WHERE configuration_key='" . $key . "'");
        }
      }
      xtc_redirect(xtc_href_link('paypal_module.php'));
      break;

    case 'install':
      if (in_array($_GET['module'], $payment_array)) {                  
        require_once(DIR_FS_CATALOG.'includes/modules/payment/'.$_GET['module'].'.php');
        $module = new $_GET['module']();
        $module->install();
        
        $installed_modules = explode(';', MODULE_PAYMENT_INSTALLED);
        if (!in_array($_GET['module'].'.php', $installed_modules)) {
          $installed_modules[] = $_GET['module'].'.php';
          xtc_db_query("UPDATE " . TABLE_CONFIGURATION . " 
                           SET configuration_value = '" . implode(';', $installed_modules) . "', 
                               last_modified = now() 
                         WHERE configuration_key = 'MODULE_PAYMENT_INSTALLED'");
        }
      }
      xtc_redirect(xtc_href_link('paypal_module.php'));
      break;
  }
}

require_once(DIR_WS_INCLUDES.'header.php');
?>
<table class="table table-striped table-bordered">
	<tr>
		<th colspan="5"><?php echo TEXT_PAYPAL_MODULE_HEADING_TITLE; ?></th>
	</tr>
	</tr>
	  <?php
		echo '<td><a href="'.xtc_href_link('paypal_config.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_CONFIG.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_profile.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_PROFILE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_webhook.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_WEBHOOK.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_module.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_MODULE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_payment.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_TRANSACTIONS.'</a></td>';
	  ?>
	</tr>
</table>

<table class="table table-striped table-bordered">
<?php
  if (isset($_GET['action']) && $_GET['action'] == 'edit') {
	if (in_array($_GET['module'], $payment_array)) {
	  echo xtc_draw_form('config', 'paypal_module.php', xtc_get_all_get_params(array('action')).'action=update');
	  require_once(DIR_FS_CATALOG.'includes/modules/payment/'.$_GET['module'].'.php');
	  require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/'.$_GET['module'].'.php');

	  $module = new $_GET['module'];                  
	  $module_info = get_module_info($module);
	  $mInfo = new objectInfo($module_info);

	  reset($mInfo->keys);
	  while (list($key, $value) = each($mInfo->keys)) {
		?>
		<tr>
		  <td><?php echo $value['title']; ?></td>
		  <td>
		  <?php 
			if ($value['set_function']) {
			  eval('echo ' . $value['set_function'] . "'" . $value['value'] . "', '" . $key . "');");
			} else {
			  echo xtc_draw_input_field('configuration[' . $key . ']', $value['value'], 'style="width: 300px;"');
			}
		  ?>
		  </td>
		  <td><?php echo $value['description']; ?></td>
		</tr>
		<?php
	  }
	  if ($module->code == 'paypalcart') {
		?>
		<tr>
		  <td><?php echo TEXT_PAYPAL_MODULE_LINK_PRODUCT; ?></td>
		  <td><?php echo draw_on_off_selection('config[profile][MODULE_PAYMENT_'.strtoupper($module->code).'_SHOW_PRODUCT]', $status_array, (($paypal->get_config('MODULE_PAYMENT_'.strtoupper($module->code).'_SHOW_PRODUCT') == '1') ? true : false)); ?></td>
		  <td><?php echo TEXT_PAYPAL_MODULE_LINK_PRODUCT_INFO; ?></td>
		</tr>
		<?php
	  }

	  $list = $paypal->list_profile();
	  $profile_array = array(array('id' => '', 'text' => TEXT_PAYPAL_NO_PROFILE));
	  
	  if (count($list) > 0) {
		$profile_array = array(array('id' => '', 'text' => TEXT_PAYPAL_STANDARD_PROFILE));
		for ($i=0, $n=count($list); $i<$n; $i++) {
		  $profile_array[] = array('id' => $list[$i]['id'], 'text' => $list[$i]['name']);
		}
	  }
	  for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
	  ?>
	  <tr>
		<td><?php echo xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image'], $languages[$i]['name']); ?>&nbsp;<?php echo TEXT_PAYPAL_MODULE_PROFILE; ?></td>
		<td><?php echo xtc_draw_pull_down_menu('config[profile][PAYPAL_'.strtoupper($module->code.'_'.$languages[$i]['code']).'_PROFILE]', $profile_array, $paypal->get_config('PAYPAL_'.strtoupper($module->code.'_'.$languages[$i]['code']).'_PROFILE')); ?></td>
		<td>&nbsp;</td>
	  </tr>
	  <?php
	  }
								   
	  if ($module->code == 'paypalplus') {
		if (xtc_not_null(MODULE_PAYMENT_INSTALLED)) {
		  $thirdparty_module = explode(';', MODULE_PAYMENT_PAYPAL_PLUS_THIRDPARTY_PAYMENT);
		  $module_array = explode(';', MODULE_PAYMENT_INSTALLED);
		  $thirdparty_exists = false;
		  for ($p=0, $x=sizeof($module_array); $p<$x; $p++) {
			$module_name = substr($module_array[$p], 0,-4);
			if (!in_array($module_name, $payment_array)) {
			  $thirdparty_exists = true;
			}
		  }
		  if ($thirdparty_exists === true) {
			?>
			<tr>
			  <td><?php echo TABLE_HEADING_MODULES; ?></td>
			  <td><?php echo TABLE_HEADING_WALL_STATUS; ?></td>
			  <td><?php echo TABLE_HEADING_WALL_DESCRIPTION; ?></td>
			</tr>
			<?php                      
			for ($p=0, $x=sizeof($module_array); $p<$x; $p++) {
			  $module_name = substr($module_array[$p], 0,-4);
			  if (!in_array($module_name, $payment_array)) {
				if (file_exists(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/payment/' . $module_array[$p])) {
				  include_once(DIR_FS_LANGUAGES . $_SESSION['language'] . '/modules/payment/' . $module_array[$p]);
				}
				?>
				<tr>
				  <td><?php echo strip_tags(constant('MODULE_PAYMENT_'.strtoupper($module_name).'_TEXT_TITLE')).'<br/>('.$module_array[$p].')'; ?></td>
				  <td><?php echo draw_on_off_selection('config[thirdparty]['.$module_name.']', $status_array, ((in_array($module_name, $thirdparty_module)) ? true : false)); ?></td>
				  <td>
					<?php
					  for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
						echo xtc_image(DIR_WS_LANGUAGES . $languages[$i]['directory'] . '/' . $languages[$i]['image'], $languages[$i]['name']);
						echo xtc_draw_textarea_field('config[description]['.strtoupper($module_name.'_'.$languages[$i]['code']).']', '', '55', '8', $paypal->get_config(strtoupper($module_name.'_'.$languages[$i]['code'])), 'style="display:block;"'); 
					  }
					?>
				  </td>
				</tr>
				<?php
			  }
			}
		  }
		}
	  }
	}
	?>
	<tr>
	  <td class="text-left" colspan="3">
		<a class="btn btn-default btn-sm" href="<?php echo xtc_href_link('paypal_module.php'); ?>"><?php echo BUTTON_CANCEL; ?></a>
		<input type="submit" class="btn btn-success btn-sm" name="submit" value="<?php echo BUTTON_UPDATE; ?>">
	  </td>
	</tr>
	</table>
	<?php              
  } else {
	?>
	  <tr>
		<th><?php echo TABLE_HEADING_MODULES; ?></th>
		<th><?php echo TABLE_HEADING_SORT_ORDER; ?></th>
		<th><?php echo TABLE_HEADING_STATUS; ?></th>
		<th><?php echo TABLE_HEADING_ACTION; ?></th>
	  </tr>
	  <?php
	  foreach ($payment_array as $payment_module) {
		require_once(DIR_FS_CATALOG.'includes/modules/payment/'.$payment_module.'.php');
		require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/'.$payment_module.'.php');
		$module = new $payment_module;
		?>
		  <tr>
			<td>
			  <?php
				echo $module->title;
				if (isset($module->icons_available)) {
				  echo '<br />'.$module->icons_available;
				}
			  ?>
			</td>
			<td>
			<?php if (isset($module->sort_order) && is_numeric($module->sort_order)) echo $module->sort_order; ?></td>
			<td>
			  <?php
				if ($module->check() > 0) {
				  if (isset($module->enabled) && $module->enabled) {
					echo '<span class="btn btn-success btn-sm"><i class="glyphicon glyphicon-ok"></i></span>';
				  } else {
					echo '<span class="btn btn-danger btn-sm"><i class="glyphicon glyphicon-remove"></i></span>';
				  }
				}
			  ?>
			</td>
			<td>
			  <?php
				if ($module->_check == 1) {
				  echo '<a class="btn btn-info btn-sm" href="'.xtc_href_link('paypal_module.php', 'action=edit&module='.$module->code).'">'.BUTTON_EDIT.'</a>';
				} else {
				  echo '<a class="btn btn-success btn-sm" href="'.xtc_href_link('paypal_module.php', 'action=install&module='.$module->code).'">'.BUTTON_MODULE_INSTALL.'</a>';                            
				}
			  ?>
			</td>
		  </tr>
		<?php
	  }
  }
?>
</table>
<?php
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
